<?php
use Illuminate\Support\Facades\Cache;

function pr($data)
{
  echo "<pre>";
  print_r($data);
  echo "</pre>";
}

function prd($data)
{
  echo "<pre>";
  print_r($data);
  echo "</pre>";
  die;
}

function getDateFormat( $date=null, $format = 'j-M-Y' ){
  if(!isset($date)) {
      $date = date("c");
  }
  return date($format, strtotime($date));
}


function setDateTime($format = 'd-M-Y'){
  if( !isset( $format ) ){
      $format = 'Y-m-d H:i:s';
  }
  $currentDateTime = Carbon::now();
  return $currentDateTime->format( $format );
}

function errorResponse($message){
  return response()->json([
            'Message'=>$message,
            'Status'=>400,
            'Type'=>'Error'
        ]);
}
function successResponse($message) {
  return response()->json([
            'Message'=>$message,
            'Status'=>200,
            'Type'=>'Success'
        ]);
}

/**
   * DB query with binding values
   * $query : String | it is a query string with `?` letter
   * $bindings : Array | array of values for every `?` letter
   */
function getQueryWithBindings($query,$bindings){
    return vsprintf(str_replace('?', '%s', $query), collect($bindings)->map(function ($binding) {
        $binding = addslashes($binding);
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}

function showDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? "Asia/Kolkata";
  $format = $format ?? "Y-m-d";

  // Convert string date to Carbon instance if it's not already
  $carbonDate = is_string($date) ? Carbon\Carbon::parse($date) : $date;

  return $carbonDate->setTimezone($timeZone)->format($format);
}

function objectFilter($object){
  foreach ($object as $key => $value) {
    // Check if the value is empty
    if (empty($value)) {
        // Remove the property from the object
        unset($object->$key);
    }
  }
  return $object;
}

function getPrecautionActionList(){
  $preType = array();
  $preType[] = array('key'=>1, 'value'=>'Closed');
  $preType[] = array('key'=>2, 'value'=>'Off');
  $preType[] = array('key'=>3, 'value'=>'Open'); 
  $preType[] = array('key'=>4, 'value'=>'On'); 
  return $preType;
}

