<?php

namespace App\Http\Requests\PTW;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Traits\EncDecService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class ListRequest extends FormRequest
{
    use EncDecService;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [];
    }
    

    protected function mandatoryFields($requestData)
    {
        $fields = ['SITE_ID'];
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                return str_replace("_", " ", strtolower($key)) . " should not be blank";
            }
        }
    }

    protected function checkNumericFields($requestData)
    {
        $numericFields = [ "SITE_ID" ,"TYPE_ID","LOCATION_ID","STAGE_ID","PAGE_NUM","PAGE_SIZE"];

        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                return "input field $numericAlias is expecting a numeric value";
            }
        }
    }


    public function listAPIInputValidation($requestData){
        $error = "";
        $mandatoryError = $this->mandatoryFields($requestData);
        if ($mandatoryError) {
            $error = $mandatoryError;
        }

        $numericError = $this->checkNumericFields($requestData);
        if ($numericError) {
            $error =  $numericError;
        }
        $pageSize = $requestData -> PAGE_SIZE;
        if( $pageSize > config("constants.PAGINATION_PER_PAGE") ){
            $error =  "Page size must be less than " . config("constants.PAGINATION_PER_PAGE").".";
        }
        return $error ;
    }

    public function editAPIInputValidation($requestData){
        $error = "";
        $fields = ['PTW_ID'];
        $vvObjsKeyList1 = array_keys((array)$requestData);
        foreach ($fields as $key) {
            if (empty($requestData->$key)) {
                $error.= str_replace("_", " ", strtolower($key)) . " should not be blank";
            }

        }
        foreach ($vvObjsKeyList1 as $vvskey) {
            if(!in_array($vvskey, $fields)){
                $error.= "Invalid input. ".str_replace("_", " ", strtolower($vvskey)) . " should not be allowed";
            }
        }        
        $numericFields = [ "PTW_ID"];
        foreach ($numericFields as $numericAlias) {
            if (isset($requestData->$numericAlias) && !is_numeric($requestData->$numericAlias)) {
                $error.= "input field $numericAlias is expecting a numeric value";
            }
        }
        
        return $error ;
    }

}
