<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PtwMapCheckListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {        
        return [
            'MAP_CHECKLIST_ID'  => $this->MAP_CHECKLIST_ID,
            'CHECKLIST_ID'      => $this->CHECKLIST_ID,
            'CHECKLIST_NAME'    => $this->CHECKLIST_NAME,
            'OPTION_ID'          => [
                                    'key'   => $this->OPTION_ID,
                                    'value' => $this->OPTION_NAME ?? ""
                                ]
        ];
    }

    


}
