<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PtwMapPrecResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $vvsPtwAction = [1=>"Closed",2=>"Off",1=>"Open",1=>"On"];
        return [
            'MAP_PRECAUTION_ID'  => $this->MAP_PRECAUTION_ID,
            'TAG_NO'             => $this->TAG_NO,
            'DEVICE'             => $this->DEVICE,
            'LOCATION'           => $this->LOCATION,
            'TAGGED_ON'          => ($this->TAGGED_ON != "") ? getDateFormat($this->TAGGED_ON,'d/m/Y') : "",
            'ACTION_ID'          => [
                                    'key'   => $this->ACTION_ID,
                                    'value' => $vvsPtwAction[$this->ACTION_ID] ?? ""
                                ]
        ];
    }

    


}
