<?php

namespace App\Http\Resources\PTW;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PtwResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "PTW_ID"            => $this->ID,
            "AUTO_GEN_REF_NO"   => $this->AUTO_GEN_NO,
            "TYPE_NAME"         => $this->type->TYPE_NAME,
            "CURR_STATE"        => "NTBD",
            "TAB"               => "NTBD",
            "PERMIT_START_TIME" => showDate($this->PERMIT_START_TIME,"Y-m-d H:i:s"),
            "PERMIT_END_TIME"   => showDate($this->PERMIT_END_TIME,"Y-m-d H:i:s"),
            "LOCATION_NAME"      => $this->location->LOCATION_NAME,
            "STAGE_ALIAS"       => $this->stage->STAGE_ALIAS
        ];
    }

    public static function transformPtw($ptwdetails,$action=null){
        if(!isset($action)) $action = "";
        return [
            'PTW_ID' => ["editable"=>false, "value"=>$ptwdetails->ID],
            'AUTO_GEN_NO' => ["editable"=>false, "value"=>$ptwdetails->AUTO_GEN_NO],
            'SITE_ID' => ["editable"=>false, "value"=>$ptwdetails->SITE_ID],
            'TYPE_ID' => ["editable"=>false, "value"=>$ptwdetails->TYPE_ID],
            'STAGE_ID' => ["editable"=>false, "value"=>$ptwdetails->STAGE_ID],
            'STATUS' => ["editable"=>false, "value"=>$ptwdetails->stage->STAGE_NAME],
            'LOCATION_ID'  => [
                            "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                            "value"=>$ptwdetails->LOCATION_ID
                        ],
            'SOP_POLICY_ID'  => [
                            "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                            "value"=>explode(',',$ptwdetails->SOP_POLICY_ID)
                        ],
            'HIRA_REFERENCE_NO'  => [
                            "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                            "value"=>explode(',',$ptwdetails->HIRA_REFERENCE_NO)
                        ],
            'DESCRIPTION'  => [
                            "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                            "value"=>$ptwdetails->DESCRIPTION
                        ],
            'IS_CONTRACTOR_INFO_REQUIRED'  => [
                        "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                         "value"=>$ptwdetails->IS_CONTRACTOR_INFO_REQUIRED
                        ],
            'CONTRACTOR_ID'  => [
                        "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                         "value"=>$ptwdetails->CONTRACTOR_ID
                        ],
            'REMARKS'  => [
                    "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                     "value"=>$ptwdetails->REMARKS
                    ],
            'PERMIT_START_TIME'  => [
                    "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                     "value"=>getDateFormat($ptwdetails->PERMIT_START_TIME,'d/m/Y')
                    ],
            'PERMIT_END_TIME'  => [
                    "editable"=>(($ptwdetails->STAGE_ID==1 && $action!='view')?true:false),
                     "value"=>getDateFormat($ptwdetails->PERMIT_END_TIME,'d/m/Y')
                    ],
        ];
    }


}
