<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        
        $this->app->bind(
            'App\Repositories\PTW\PtwInterface',
            'App\Repositories\PTW\PtwRepository'
        );
        $this->app->bind(
            'App\Repositories\PTW\PtwMasterListInterface',
            'App\Repositories\PTW\PtwMasterListRepository'
        );

       
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Config::set('database.connections.pgsql.host', decrypt(env('DB_HOST')));
        Config::set('database.connections.pgsql.database', decrypt(env('DB_DATABASE')));
        Config::set('database.connections.pgsql.username', decrypt(env('DB_USERNAME')));
        Config::set('database.connections.pgsql.password', decrypt(env('DB_PASSWORD')));
    }
}
