<?php

namespace App\Repositories\PTW;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class PtwPrivate extends Controller
{
    
    protected function getFileTypeFromUrl($url) {
    	$vvsreturnData = "unknown";
        $vvsurlArray = explode(".",$url);
        $vvsurlLastElement = end($vvsurlArray);
        if(in_array(strtoupper($vvsurlLastElement),['PNG','JPEG','JPG'])) $vvsreturnData = 'image';
        elseif(in_array(strtoupper($vvsurlLastElement),['PDF'])) $vvsreturnData = 'application/pdf';
        elseif(in_array(strtoupper($vvsurlLastElement),['MP4'])) $vvsreturnData = 'video';
        return $vvsreturnData;
    }

    public function getPtwFiles($vvsPtwFiles,$vvsstageId,$vvsaction=null)
    {
        $vvsPtwFileArray = array();
        $vvsuploadpath1 = config('constants.PTW_FILE_UPLOAD_PATH');
        if (!empty($vvsPtwFiles)) {
            foreach ($vvsPtwFiles as $key1 => $value1) {
                foreach ($value1->toArray() as $key2 => $value2) {
                    $vvsPtwFileArray[$key1][$key2] = $value2;
                    if ($key2 == 'FILE_NAME') {
                        $vvsimgPath = asset('public/' . $vvsuploadpath1 . $vvsPtwFileArray[$key1][$key2]);
                        $vvsimgPath = str_replace('public/public/', 'public/', $vvsimgPath);
                        $vvsPtwFileArray[$key1][$key2] = str_replace('./' . $vvsuploadpath1, '', $value2);
                        $vvsPtwFileArray[$key1]['PTW_FILE'] = $vvsimgPath;
                        $vvsPtwFileArray[$key1]['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsimgPath);
                        $vvsPtwFileArray[$key1]['IS_DELETE'] = (($vvsstageId == 1 && $vvsaction!='view')?true:false);
                    }
                }
            }
        }
        return $vvsPtwFileArray;
    }
    

}
