<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_MST_CHECKLIST");
        Schema::create('PTW_MST_CHECKLIST', function (Blueprint $table) {
            $table->bigIncrements("CHECKLIST_ID");
            $table->string("CHECKLIST_NAME",50)->nullable(false);
            $table->unsignedBigInteger("TYPE_ID")->nullable(false);
            $table->foreign("TYPE_ID")->references("TYPE_ID")->on("MST_TYPE");
            $table->integer("IS_APPLICABLE_FOR_NIGHT")->default(0);
            $table->integer("CHECKLIST_TYPE")->default(1);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_MST_CHECKLIST');
    }
};
