<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_MAP_CHECKLIST_OPTION");
        Schema::create('PTW_MAP_CHECKLIST_OPTION', function (Blueprint $table) {
            $table->bigIncrements("MAP_CHECKLIST_OPTION_ID");
            $table->unsignedBigInteger("CHECKLIST_ID")->nullable(false);
            $table->foreign("CHECKLIST_ID")->references("CHECKLIST_ID")->on("PTW_MST_CHECKLIST");
            $table->unsignedBigInteger("CHECKLIST_OPTION_ID")->nullable(false);
            $table->foreign("CHECKLIST_OPTION_ID")->references("CHECKLIST_OPTION_ID")->on("PTW_MST_CHECKLIST_OPTION");
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_MAP_CHECKLIST_OPTION');
    }
};
