<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_MAP_CHECKLIST");
        Schema::create('PTW_MAP_CHECKLIST', function (Blueprint $table) {
            $table->bigIncrements("MAP_CHECKLIST_ID");
            $table->unsignedBigInteger("PTW_ID")->nullable(false);
            $table->foreign("PTW_ID")->references("ID")->on("PTW");
            $table->unsignedBigInteger("CHECKLIST_ID")->nullable(false);
            $table->foreign("CHECKLIST_ID")->references("CHECKLIST_ID")->on("PTW_MST_CHECKLIST");
            $table->unsignedBigInteger("OPTION_ID")->nullable(false);
            $table->foreign("OPTION_ID")->references("CHECKLIST_OPTION_ID")->on("PTW_MST_CHECKLIST_OPTION");
            $table->string("CHECKLIST_NAME",50)->nullable(false);
            $table->string("OPTION_NAME",15)->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_MAP_CHECKLIST');
    }
};
