<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("USERS_MAP_ROLE");
        Schema::create('USERS_MAP_ROLE', function (Blueprint $table) {
            $table->bigIncrements("MAP_ROLE_ID");
            $table->unsignedBigInteger("USER_ID")->nullable(false);
            $table->foreign('USER_ID')->references('ID')->on('USERS');
            $table->unsignedBigInteger("ROLE_ID")->nullable(false);
            $table->foreign('ROLE_ID')->references('ROLE_ID')->on('MST_ROLE');
            $table->string("ROLE_NAME",100)->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('USERS_MAP_ROLE');
    }
};
