<?php

namespace Database\Seeders;

use App\Models\Ptw;
use App\Models\PtwMapDeclaration;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMapDeclarationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PtwMapDeclaration::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $ptwIds = Ptw::pluck('ID')->all();
       
 
        for ($i = 0; $i < 10; $i++) {
            PtwMapDeclaration::create([
                "PTW_ID" => $ptwIds[array_rand($ptwIds)],
                "DECLARATION_NAME" => $vvsFaker->sentence,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
