<?php

namespace Database\Seeders;

use App\Models\Ptw;
use App\Models\PtwMapPrecautions;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMapPrecautionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PtwMapPrecautions::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $ptwIds = Ptw::pluck('ID')->all();
       
 
        for ($i = 0; $i < 20; $i++) {
            PtwMapPrecautions::create([
                "PTW_ID" => $ptwIds[array_rand($ptwIds)],
                "TAG_NO" => $vvsFaker->word,
                "DEVICE" => $vvsFaker->word,
                "LOCATION" => $vvsFaker->word,
                "ACTION_ID" => rand(1, 4),
                "TAGGED_BY" => $userIds[array_rand($userIds)],
                "TAGGED_ON" => $vvsFaker->dateTime,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
