<?php

namespace Database\Seeders;

use App\Models\PtwMstStage;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstStageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
        PtwMstStage::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
       
 
        for ($i = 0; $i < 3; $i++) {
            PtwMstStage::create([
                "STAGE_NAME" => $vvsFaker->word,
                "STATUS_ALIAS" => $vvsFaker->word,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
