<?php

namespace Database\Seeders;

use App\Models\PtwMstContractor;
use App\Models\PtwMstSite;
use App\Models\PtwMstWorker;
use App\Models\PtwMstWorkerDsg;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstWorkerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
       PtwMstWorker::truncate();

       $vvsFaker = \Faker\Factory::create();
       $userIds = User::pluck('ID')->all();
       $siteIds = PtwMstSite::pluck('SITE_ID')->all();
       $workerDesignationIds = PtwMstWorkerDsg::pluck('WORKER_DESG_ID')->all();
       $contractorIds = PtwMstContractor::pluck('CONTRACTOR_ID')->all();

       for ($i = 0; $i < 20; $i++) {
        PtwMstWorker::create([
                "SITE_ID" => $siteIds[array_rand($siteIds)],
               "WORKER_NAME" => $vvsFaker->word,
               "WORKER_DESG_ID" => $workerDesignationIds[array_rand($workerDesignationIds)],
               "WORKER_CONTRACTOR_ID" => $contractorIds[array_rand($contractorIds)],
               "WORKER_AUTO_GEN_ID" => $vvsFaker -> word,
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
