<?php

namespace Database\Seeders;

use App\Models\PtwMstLocation;
use App\Models\UserMapLocation;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserMapLocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        UserMapLocation::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $locationIds = PtwMstLocation::pluck('SITE_ID')->all();
       
 
        for ($i = 0; $i < 20; $i++) {
            UserMapLocation::create([
                "LOCATION_NAME" => $vvsFaker->word,
                "LOCATION_ID" => $locationIds[array_rand($locationIds)],
                "USER_ID" => $userIds[array_rand($userIds)],
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
