<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Http\Traits\EncDecService;

use App\Http\Resources\SiteResource;

class AuthControllerV1 extends Controller
{
    use EncDecService;

    public function login(Request $request){
        $rawRequest = $this->customDecrypt($request->x_key);
        if( gettype($rawRequest) == "object" ){
            $requestJSON = (object)$rawRequest;
            $requestArray = ['EMAIL' => $requestJSON -> EMAIL , 'PASSWORD' => "password"];
        }else{
            $requestArray = $this->convertStringToJSON($rawRequest);
            $requestJSON = (object) ($requestArray);
        }

        $request->validate([$requestArray]);

        $user = User::where('EMAIL', $requestJSON->EMAIL)->first();
        if (!$user) {
            $output = [
                'ResponseCode'  => config('constants.FAILURE_RESPONSE_STATUS_CODE'),
                'Response' => 'The provided credentials are incorrect.'
            ];
            $jsonOutput = $this->customEncrypt($output);
            return response()->json(["x_key" =>$jsonOutput]);
        }

        $createToken = $user->createToken('api-token');
        $accessToken = $createToken->accessToken;        

        $responseData = [
                            'token' => $accessToken->token,
                            "data"  => [
                                        "USER"=>[
                                                    "USER_ID" => $user->ID,
                                                    "NAME" =>  $this->customEncrypt($user -> FIRST_NAME." ".$user -> LAST_NAME)
                                        ],
                                        "USER_EMAIL" =>  $this->customEncrypt($user -> EMAIL),
                                        "USER_ID" => $user -> ID,
                                        "ROLES" => $user -> roles,
                                        "SITES" => SiteResource::collection($user -> sites),
                                        "LOCATIONS" => $user -> locations,
                                        "X_API_KEY" => Hash::make($accessToken->token)
                                        ]
                                    ];        
        $jsonData = ["ResponseCode" =>  config('constants.SUCCESS_RESPONSE_STATUS_CODE'),"Response"=>$responseData];
        $jsonOutput = $this->customEncrypt($jsonData);
        return response()->json(["x_key" =>$jsonOutput]);
    }
}
