<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ptw extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'PTW';
    public $timestamps = false;

    public $fillable = ["SITE_ID","AUTO_GEN_NO","TYPE_ID","LOCATION_ID","PERMIT_START_TIME","PERMIT_END_TIME","SOP_POLICY_ID","HIRA_REFERENCE_NO","DESCRIPTION","IS_CONTRACTOR_INFO_REQUIRED","CONTRACTOR_ID","STAGE_ID","REMARKS"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }

    public function type()
    {
        return $this->belongsTo(PtwMstType::class, 'TYPE_ID', 'TYPE_ID');
    }

    public function location()
    {
        return $this->belongsTo(PtwMstLocation::class, 'LOCATION_ID', 'LOCATION_ID');
    }

    public function sopPolicy()
    {
        return $this->belongsTo(PtwMstSoapPolicies::class, 'SOP_POLICY_ID', 'SOP_POLICY_ID');
    }

    public function contractor()
    {
        return $this->belongsTo(PtwMstContractor::class, 'CONTRACTOR_ID', 'CONTRACTOR_ID');
    }

    public function stage()
    {
        return $this->belongsTo(PtwMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }

    public function precausions()
    {
        return $this->hasMany(PtwMapPrecautions::class, 'PTW_ID');
    }

    public function checkLists()
    {
        return $this->hasMany(PtwMapChecklist::class, 'PTW_ID');
    }

    public function files()
    {
        return $this->hasMany(PtwMapFiles::class, 'PTW_ID');
    }
}
