<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory;
    use HasFactory, Notifiable, HasApiTokens;
    protected $primaryKey = 'ID';

    protected $table = 'USERS';
    public $timestamps = false;

    public $fillable = ["EMAIL","FIRST_NAME","LAST_NAME","IS_INFO_REDUCTED"];

    public function locations()
    {
        return $this->hasMany(UserMapLocation::class, 'USER_ID')->where('IS_DELETED', '=', 0);
    }

    public function roles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0);
    }

    public function sites()
    {
        return $this->hasMany(UserMapSite::class, 'USER_ID')->where('IS_DELETED', '=', 0);
    }

}
