<?php

namespace App\Repositories\PTW;

use App\Http\Requests\PTW\MasterListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\PTW\PtwMstTypeServices;
use App\Services\PTW\PtwMstServices;
use App\Services\LocationServices;
use App\Services\PTW\PtwMstContractorServices;
use App\Services\PTW\PtwMstSoapPoliciesServices;
use App\Services\PTW\PtwMstStageServices;
use App\Services\PTW\PtwMstWorkerDsgServices;
use App\Services\PTW\PtwMstWorkerServices;
use App\Services\PTW\PtwCheckListServices;
use App\Services\PTW\PtwMstDeclarationServices;

use App\Models\MstLocation;
use App\Models\PtwMstSoapPolicies;
use App\Models\PtwMstContractor;
use App\Models\PtwMstWorkerDsg;
use App\Models\PtwMstStage;
use App\Models\PtwMstWorker;

use App\Http\Resources\PTW\PtwMstTypeResource;
use App\Http\Resources\PTW\LocationResource;
use App\Http\Resources\PTW\PtwMstSoapPoliciesResource;
use App\Http\Resources\PTW\PtwMstContractorResource;
use App\Http\Resources\PTW\PtwMstWorkerDsgResource;
use App\Http\Resources\PTW\PtwMstStageResource;
use App\Http\Resources\PTW\PtwMstWorkerResource;
use App\Http\Resources\PTW\PtwCheckListOptionResource;
use App\Http\Resources\PTW\PtwCheckListResource;
use App\Http\Resources\PTW\PtwMstDeclarationResource;

class PtwMasterListRepository implements PtwMasterListInterface
{
    use EncDecService;
    public $vvsPtwTypeService;
    public $vvsLocationService;
    public $vvsPtwContService;
    public $vvsPtwSopService;
    public $vvsPtwStageService;
    public $vvsPtwDesigService;
    public $vvsPtwWorkerService;
    public $vvsPtwCheckListService;
    public $vvsPtwDeclService;
    public $vvsPtwListRequest;
   
    public function __construct()
    {
      $this->vvsPtwTypeService = new PtwMstTypeServices();
      $this->vvsLocationService = new LocationServices();
      $this->vvsPtwContService = new PtwMstContractorServices();
      $this->vvsPtwSopService = new PtwMstSoapPoliciesServices();
      $this->vvsPtwStageService = new PtwMstStageServices();
      $this->vvsPtwDesigService = new PtwMstWorkerDsgServices();
      $this->vvsPtwWorkerService = new PtwMstWorkerServices();
      $this->vvsPtwCheckListService = new PtwCheckListServices();
      $this->vvsPtwDeclService = new PtwMstDeclarationServices();

      $this->vvsPtwListRequest = new MasterListRequest();

    }

   public function masterListPtw(Request $request){
        try {
            $vvsRawRequest = $this->customDecrypt($request->x_key);
            $vvsValidationErrorData = $this->vvsPtwListRequest->masterAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($validationErrorData);
            }

            //PTW TYPE
            $vvsPtwtypes = $this->vvsPtwTypeService->getPtwTypeList();
            $vvsMasterData["VVSPtwTypes"] = PtwMstTypeResource::collection($vvsPtwtypes);
           
            
            //PTW SOP
            $vvsPtwSops = $this->vvsPtwSopService->getPtwSopList();
            $vvsMasterData["VVSPtwSops"] = PtwMstSoapPoliciesResource::collection($vvsPtwSops);

            //PTW WORKER DESIGNATION
            $vvsPtwWorkDesg = $this->vvsPtwDesigService->getPtwWorkDesgList();
            $vvsMasterData["VVSPtwWorkerDesg"] = PtwMstWorkerDsgResource::collection($vvsPtwWorkDesg);

            //PTW STAGES
            $vvsPtwStages = $this->vvsPtwStageService->getPtwStageList();
            $vvsMasterData["VVSPtwStages"] = PtwMstStageResource::collection($vvsPtwStages);

            //LOCATIONS
            $vvsPtwLocations = $this->vvsLocationService->getLocationList();
            $vvsMasterData["VVSPtwLocations"] = LocationResource::collection($vvsPtwLocations);

            //PTW CONTRACTORS
            $vvsPtwContractors = $this->vvsPtwContService->getPtwContList($vvsRawRequest);
            $vvsMasterData["VVSPtwContractors"] = PtwMstContractorResource::collection($vvsPtwContractors);

            //PTW WORKERS
            $vvsPtwWorkers = $this->vvsPtwWorkerService->getPtwWorkerList($vvsRawRequest);
            $vvsMasterData["PtwWorkers"] = PtwMstWorkerResource::collection($vvsPtwWorkers);

            //PTW DECLARATION
            $vvsPtwDeclarations = $this->vvsPtwDeclService->getPtwSDeclarationList();
            $vvsMasterData["PtwDeclarations"] = PtwMstDeclarationResource::collection($vvsPtwDeclarations);

            //PRECAUSION ACTION LIST
            $vvsPreType = getPrecautionActionList();
            $vvsMasterData["PtwPrecausionActionList"] = $vvsPreType;
            
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function masterChekListPtw(Request $request){
        try {
            $vvsRawRequest = $this->customDecrypt($request->x_key);
            $vvsValidationErrorData = $this->vvsPtwListRequest->checkListAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }
            //PTW CHECKLIST
            $vvsPtwCheckList = $this->vvsPtwCheckListService->getPtwWCheckList($vvsRawRequest);
            foreach ($vvsPtwCheckList as $vvsValue) {
                $vvsValue->OPTIONS1 = PtwCheckListOptionResource::collection($vvsValue->options);
                
            }
            $vvsMasterData["VVSCheckList"] = PtwCheckListResource::collection($vvsPtwCheckList);
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}
