<?php

namespace App\Repositories\PTW;

use App\Http\Requests\PTW\ListRequest;
use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\PTW\PtwServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\PTW\PtwResource;
use App\Http\Resources\PTW\PtwMapPrecResource;
use App\Http\Resources\UserResource;
use App\Http\Resources\PTW\PtwMapCheckListResource;
use App\Repositories\PTW\PtwPrivate;

class PtwRepository implements PtwInterface
{
    use EncDecService;
    public $vvsPtwService;
    public $vvsPtwListRequest;
    public $vvsPtwPrivate;

    public $vvsUserService;


    /**
     * PtwRepository constructor.
     */
   
    public function __construct()
    {
      $this->vvsPtwService = new PtwServices();
      $this->vvsPtwListRequest = new ListRequest();
      $this->vvsPtwPrivate = new PtwPrivate();
      $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return PtwResource
     */
    public function listPtw(Request $request){
        try {
            $requestData = $this->customDecrypt ($request->x_key);

            $validationErrorData = $this->vvsPtwListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsPtwData = $this->vvsPtwService->getPtwList($requestData);
                return $this->successMessage( PtwResource::collection( $vvsPtwData));
            }else {
                return $this->failureMessage($validationErrorData);
            }
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return PtwResource
     */
    public function ptwDetails(Request $request){
        try {
            $error = "";
            $vvsRequestData = $this->customDecrypt ($request->x_key);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                $error =$this->failureMessage("Token mismatch");
            }
            if(trim($error)== ""){
                //$vvsRoles = $vvsUserData->roles->pluck('ROLE_ID');
                $vvsValidationErrorData = $this->vvsPtwListRequest->editAPIInputValidation($vvsRequestData);
                if (trim($vvsValidationErrorData) != "") {
                    $error = $this->failureMessage($vvsValidationErrorData);
                }
            }
            if(trim($error)== ""){
            $vvsaction = isset($vvsRequestData -> ACTION) ? $vvsRequestData -> ACTION : "";
            $vvsPtwData = $this->vvsPtwService->getPtwDetails($vvsRequestData);
            $vvsPtwOutput = PtwResource::transformPtw( $vvsPtwData);
            $vvsPtwOutput["PRECAUSIONS"]["editable"] = false;
            $vvsPtwOutput["CHECKLISTS"]["editable"] = false;
            if($vvsaction !== "view" && $vvsPtwData->STAGE_ID == 1){
                $vvsPtwOutput["PRECAUSIONS"]["editable"] = true;
                $vvsPtwOutput["CHECKLISTS"]["editable"] = true;
            }
            $vvsPtwOutput["PRECAUSIONS"]["value"] = PtwMapPrecResource::collection($vvsPtwData->precausions);
            $vvsPtwOutput["CHECKLISTS"]["value"] = PtwMapCheckListResource::collection($vvsPtwData->checkLists);
            $vvsPtwFiles =  $this->vvsPtwPrivate->getPtwFiles($vvsPtwData->files,$vvsPtwData->STAGE_ID,$vvsaction);
            $vvsPtwOutput["PTW_FILES"]["editable"] = true;
            $vvsPtwOutput["PTW_FILES"]["value"] = $vvsPtwFiles;

            $vvsIsForwardBtn = false;
            $vvsIsSendBackBtn = false;
            $vvsIsApproveBtn = false;
            $vvsIsRejectBtn = false;
            $vvsIsCloseReqBtn = false;
            $vvsIsCloseBtn = false;
            $vvsIsSuspendBtn = false;

            $vvsPtwOutput["IS_FORWARD_BTN"] = $vvsIsForwardBtn;
            $vvsPtwOutput["IS_SEND_BACK_BTN"] = $vvsIsSendBackBtn;
            $vvsPtwOutput["IS_APPROVE_BTN"] = $vvsIsApproveBtn;
            $vvsPtwOutput["IS_REJECT_BTN"] = $vvsIsRejectBtn;
            $vvsPtwOutput["IS_CLOSE_REQ_BTN"] = $vvsIsCloseReqBtn;
            $vvsPtwOutput["IS_CLOSE_BTN"] = $vvsIsCloseBtn;
            $vvsPtwOutput["IS_SUSPEND_BTN"] = $vvsIsSuspendBtn;
            $error = $this->successMessage($vvsPtwOutput);
            }
            return $error;
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}
