<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists("PTW_MST_WORKERS");
        Schema::create('PTW_MST_WORKERS', function (Blueprint $table) {
            $table->bigIncrements("WORKER_ID");
            $table->unsignedBigInteger("SITE_ID")->nullable(false);
            $table->foreign("SITE_ID")->references("SITE_ID")->on("MST_SITE");
            $table->string("WORKER_NAME",80)->nullable(false);
            $table->unsignedBigInteger("WORKER_DESG_ID")->nullable(false);
            $table->foreign("WORKER_DESG_ID")->references("WORKER_DESG_ID")->on("PTW_MST_WORKER_DSG");
            $table->unsignedBigInteger("WORKER_CONTRACTOR_ID")->nullable(false);
            $table->foreign("WORKER_CONTRACTOR_ID")->references("CONTRACTOR_ID")->on("PTW_MST_CONTRACTOR");
            $table->string("WORKER_AUTO_GEN_ID",40)->nullable(false);
            $table->integer("CREATED_BY")->nullable(false);
            $table->timestamp('CREATED_ON')->useCurrent();
            $table->string("MODIFIED_BY")->nullable();
            $table->timestamp('MODIFIED_ON')->nullable();
            $table->integer("IS_ACTIVE")->default(1);
            $table->integer("IS_DELETED")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('PTW_MST_WORKERS');
    }
};
