<?php

namespace Database\Seeders;

use App\Models\MstLocation;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MstLocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
       //lets truncate the existing records
       MstLocation::truncate();

       $vvsFaker = \Faker\Factory::create();
      
       $userIds = User::pluck('ID')->all();

       for ($i = 0; $i < 5; $i++) {
        MstLocation::create([
               "LOCATION_NAME" => $vvsFaker->word,
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
