<?php

namespace Database\Seeders;

use App\Models\MstRole;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MstRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
       MstRole::truncate();

       $vvsFaker = \Faker\Factory::create();
       $userIds = User::pluck('ID')->all();

       for ($i = 0; $i < 3; $i++) {
        MstRole::create([
               "ROLE_NAME" => $vvsFaker->word,
               "CREATED_BY" => $userIds[array_rand($userIds)],
           ]);
       }
    }
}
