<?php

namespace Database\Seeders;

use App\Models\PtwMapChecklistOption;
use App\Models\PtwMstChecklist;
use App\Models\PtwMstChecklistOption;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMapChecklistOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //lets truncate the existing records
        PtwMapChecklistOption::truncate();

        $userIds = User::pluck('ID')->all();
        $checkListIds = PtwMstChecklist::pluck('CHECKLIST_ID')->all();
        $checkListOptionIds = PtwMstChecklistOption::pluck('CHECKLIST_OPTION_ID')->all();
 
        for ($i = 0; $i < 10; $i++) {
            PtwMapChecklistOption::create([
                "CHECKLIST_ID" => $checkListIds[array_rand($checkListIds)],
                "CHECKLIST_OPTION_ID" => $checkListOptionIds[array_rand($checkListOptionIds)],
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
