<?php

namespace Database\Seeders;

use App\Models\PtwMstLocation;
use App\Models\PtwMstSite;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwMstLocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PtwMstLocation::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $siteIds = PtwMstSite::pluck('SITE_ID')->all();
       
 
        for ($i = 0; $i < 10; $i++) {
            PtwMstLocation::create([
                "LOCATION_NAME" => $vvsFaker->word,
                "SITE_ID" => $siteIds[array_rand($siteIds)],
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
