<?php

namespace Database\Seeders;

use App\Models\MstLocation;
use App\Models\Ptw;
use App\Models\PtwMstContractor;
use App\Models\PtwMstSite;
use App\Models\PtwMstSoapPolicies;
use App\Models\PtwMstStage;
use App\Models\PtwMstType;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PtwSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Ptw::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $siteIds = PtwMstSite::pluck('SITE_ID')->all();
        $typeIds = PtwMstType::pluck('TYPE_ID')->all();
        $locationIds = MstLocation::pluck('LOCATION_ID')->all();
        $soapIds = PtwMstSoapPolicies::pluck('SOP_POLICY_ID')->all();
        $contractorIds = PtwMstContractor::pluck('CONTRACTOR_ID')->all();
        $stageIds = PtwMstStage::pluck('STAGE_ID')->all();
 
        for ($i = 0; $i < 50; $i++) {
            Ptw::create([
                "SITE_ID" => $siteIds[array_rand($siteIds)],
                "AUTO_GEN_NO" => $vvsFaker->randomNumber,
                "TYPE_ID" => $typeIds[array_rand($typeIds)],
                "LOCATION_ID" => $locationIds[array_rand($locationIds)],
                "PERMIT_START_TIME" => $vvsFaker->dateTime,
                "PERMIT_END_TIME" => $vvsFaker->dateTime,
                "SOP_POLICY_ID" => $soapIds[array_rand($soapIds)],
                "HIRA_REFERENCE_NO" => 1,
                "DESCRIPTION" => $vvsFaker -> sentence,
                "IS_CONTRACTOR_INFO_REQUIRED" => 1,
                "CONTRACTOR_ID" => $contractorIds[array_rand($contractorIds)],
                "STAGE_ID" => $stageIds[array_rand($stageIds)],
                "REMARKS" => $vvsFaker -> word,
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
