<?php

namespace Database\Seeders;

use App\Models\PtwMstSite;
use App\Models\PtwMstType;
use App\Models\UserMapSite;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserMapSiteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        UserMapSite::truncate();
        $vvsFaker = \Faker\Factory::create();
        $userIds = User::pluck('ID')->all();
        $siteIds = PtwMstSite::pluck('SITE_ID')->all();
       
 
        for ($i = 0; $i < 20; $i++) {
            UserMapSite::create([
                "SITE_NAME" => $vvsFaker->word,
                "SITE_ID" => $siteIds[array_rand($siteIds)],
                "USER_ID" => $userIds[array_rand($userIds)],
                "CREATED_BY" => $userIds[array_rand($userIds)],
            ]);
        }
    }
}
