<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
         //lets truncate the existing records
       User::truncate();

       $vvsFaker = \Faker\Factory::create();
       // And now, let's create a few PTW in our database:

       for ($i = 0; $i < 20; $i++) {
        User::create([
               "EMAIL" => $vvsFaker->unique()->safeEmail(),
               "FIRST_NAME" => $vvsFaker->firstName,
               "LAST_NAME" => $vvsFaker->lastName,
               "CREATED_BY" => $i+1
           ]);
       }
    }
}
